CREATE EXTENSION pg_stat_statements;

-- We need to grant access to pg_stat_statements to cron, but in MDB this action is restricted even for db owner.
-- Instead, they provide special role "mdb_admin" that one can grant to users.
CREATE ROLE mdb_admin;
GRANT pg_monitor to mdb_admin;

-- dbstats monitors current migration version via select from `schema_version` - table that pgmigrate provides.
-- Since we are not using pgmigrate in devpack atm, we create this table by ourselves.
CREATE TABLE public.schema_version ( 
    version      bigint,
    description  text,
    type         text,
    installed_by text,
    installed_on timestamp without time zone
);
