
CREATE TYPE impl.changelog_counters AS (
    fresh_count      bigint,
    useful_new_count bigint
);

CREATE TYPE impl.changed_folder AS (
    fid        integer,
    name       text,
    type       mail.folder_types,
    parent_fid integer
);

CREATE TYPE impl.changed_label AS (
    lid  integer,
    name text,
    type mail.labels_types
);

-- used in code.quick_save_messages
CREATE TYPE impl.quick_saved_message AS (
    mid      bigint,
    fid      int,
    st_id    text,
    revision bigint
);

CREATE TYPE impl.changed_message AS (
    mid     bigint,
    tid     bigint,
    fid     integer,
    seen    boolean,
    recent  boolean,
    deleted boolean,
    lids    integer[],
    hdr_message_id text,
    tab     mail.tab_types
);

CREATE TYPE impl.deleted_message AS (
    mid     bigint,
    src_fid integer
);

CREATE TYPE impl.changed_message_with_src_fid_tab AS (
    mid     bigint,
    tid     bigint,
    fid     integer,
    src_fid integer,
    seen    boolean,
    recent  boolean,
    deleted boolean,
    lids    integer[],
    tab     mail.tab_types,
    src_tab mail.tab_types
);

CREATE TYPE impl.short_changed_message AS (
    mid     bigint,
    tid     bigint,
    fid     integer,
    seen    boolean,
    recent  boolean,
    deleted boolean,
    lids    integer[],
    tab     mail.tab_types
);

CREATE TYPE impl.changed_with_fids AS (
    changed_fids int[],
    changed      jsonb
);

-- extension of impl.deleted_message for sync operation
CREATE TYPE impl.synced_deleted_message AS (
    owner_uid bigint,
    owner_mid bigint,
    owner_fid integer,
    mid       bigint,
    src_fid   integer
);

-- extension of impl.short_changed_message for sync operation
CREATE TYPE impl.synced_short_changed_message AS (
    owner_uid bigint,
    owner_mid bigint,
    owner_fid integer,
    mid       bigint,
    tid       bigint,
    fid       integer,
    seen      boolean,
    recent    boolean,
    deleted   boolean,
    lids      integer[]
);

-- extension of impl.changed_message for sync operation
CREATE TYPE impl.synced_changed_message AS (
    owner_uid      bigint,
    owner_mid      bigint,
    owner_fid      integer,
    mid            bigint,
    tid            bigint,
    fid            integer,
    seen           boolean,
    recent         boolean,
    deleted        boolean,
    lids           integer[],
    hdr_message_id text
);
