-- misc helpers
CREATE TYPE impl.first_unseen_def AS (
    first_unseen    integer,
    first_unseen_id bigint
);

CREATE TYPE impl.mid_with_date AS (
    mid           bigint,
    received_date timestamp with time zone
);

CREATE TYPE impl.chained_message AS (
    imap_id bigint,
    chain   smallint
);

CREATE TYPE impl.attaches_info AS (
    attach_count smallint,
    attach_size  integer
);

-- used in code.update_messages
CREATE TYPE impl.updated_message AS (
    mid            bigint,
    fid            integer,
    tid            bigint,
    imap_id        bigint,
    revision       bigint,
    seen_change    integer,
    recent_change  integer,
    deleted_change integer,
    lids_diff      mail.thread_label[],
    lids_seen_diff mail.thread_label[],
    new_seen       boolean,
    new_recent     boolean,
    new_deleted    boolean,
    new_lids       integer[],
    tab            mail.tab_types
);

CREATE TYPE impl.moved_message AS (
    mid            bigint,
    dst_fid        integer,
    src_fid        integer,
    dst_tid        bigint,
    src_tid        bigint,
    dst_imap_id    bigint,
    src_imap_id    bigint,
    src_chain      smallint,
    seen           boolean,
    recent         boolean,
    deleted        boolean,
    lids           integer[],
    size           integer,
    received_date  timestamp with time zone,
    old_newest_tif boolean,
    ai             impl.attaches_info,
    hdr_message_id text,
    attributes     mail.message_attributes[],
    dst_tab        mail.tab_types,
    src_tab        mail.tab_types,
    old_newest_tit boolean
);

CREATE TYPE impl.message_for_copy AS (
    src_mid bigint,
    dst_mid bigint,
    row_num bigint
);

CREATE TYPE impl.request_info AS (
    x_request_id    text,
    session_key     text
);

CREATE TYPE impl.welcome_type AS ENUM (
    'en-int',
    'en-rus',
    'en-tur',
    'ru-rus',
    'tr-tur',
    'uk-ua'
);


-- impl.store_message types

CREATE TYPE impl.store_coordinates AS (
    fid           integer,
    tid           bigint,
    seen          boolean,
    deleted       boolean,
    st_id         text,
    received_date timestamp with time zone,
    size          integer,
    attributes    mail.message_attributes[],
    tab           mail.tab_types
);

-- remove extra_data - MAILPG-313
CREATE TYPE impl.store_headers AS (
    subject         text,
    firstline       text,
    hdr_date        timestamp with time zone,
    hdr_message_id  text,
    extra_data      text
);

-- remove sort_options - MAILPG-311
CREATE TYPE impl.store_threading AS (
    rule              mail.threads_merge_rules,
    references_hashes numeric[],
    in_reply_to_hash  numeric,
    hash_value        numeric,
    hash_namespace    mail.thread_hash_namespaces,
    hash_uniq_key     bigint,
    sort_options      text
);

-- include all fields from changed_message
-- for change_log insert
CREATE TYPE impl.store_result AS (
    mid            bigint,
    tid            bigint,
    fid            integer,
    imap_id        bigint,
    seen           boolean,
    recent         boolean,
    deleted        boolean,
    lids           integer[],
    hdr_message_id text,
    fresh_count    bigint,
    revision       bigint,
    tab            mail.tab_types
);

CREATE TYPE impl.purged_message_with_st_id AS (
    mid          bigint,
    recipients   mail.recipient[],
    size         integer,
    deleted_info jsonb,
    st_id        text,
    attributes   mail.message_attributes[]
);

CREATE TYPE impl.sync_message_mapping AS (
    mid bigint,
    owner_mid bigint
);

-- helper type
-- represents rule's action
CREATE TYPE impl.action_def AS (
    ad_oper filters.action_oper_type,
    ad_param text,
    ad_verified boolean
);

-- helper type
-- represents rule's condition
CREATE TYPE impl.condition_def AS (
    cd_field_type filters.condition_field_type,
    cd_field text,
    cd_pattern text,
    cd_oper filters.condition_oper_type,
    cd_link filters.condition_link_type,
    cd_negative boolean
);

-- impl.store_deleted_message types

CREATE TYPE impl.store_deleted_coordinates AS (
    st_id         text,
    received_date timestamp with time zone,
    size          integer,
    attributes    mail.message_attributes[]
);

CREATE TYPE impl.store_deleted_result AS (
    mid      bigint,
    revision bigint
);
