CREATE OR REPLACE FUNCTION impl.check_uid_lids(
    i_uid    bigint,
    i_lids   integer[]
) RETURNS void AS $$
DECLARE
    unexisted_lids integer[];
BEGIN
    SELECT i_lids - array_agg(lid)
      FROM mail.labels
      INTO unexisted_lids
     WHERE uid = i_uid;

    IF array_length(unexisted_lids, 1) > 0 THEN
        RAISE EXCEPTION 'Following lids not found for uid=% : %', i_uid, unexisted_lids;
    END IF;
END;
$$ LANGUAGE plpgsql;