CREATE OR REPLACE FUNCTION impl.inc_thread_labels(
    i_labels mail.thread_label[],
    i_lids   integer[]
) RETURNS mail.thread_label[] AS $$
    SELECT array_agg((lid, message_count)::mail.thread_label)
      FROM (
        SELECT lid, SUM(message_count) message_count
          FROM (
        SELECT l[id].lid, l[id].message_count
          FROM (
            SELECT i_labels l, generate_subscripts(i_labels, 1) id) t
         UNION ALL
        SELECT lid, 1
          FROM unnest(i_lids) lid) t
         GROUP BY lid
    ) t;
$$ LANGUAGE SQL IMMUTABLE;