CREATE OR REPLACE FUNCTION impl.minus_thread_labels(
    ld1 mail.thread_label[],
    ld2 mail.thread_label[]
) RETURNS mail.thread_label[] AS $$
    SELECT array_agg((lid, message_count)::mail.thread_label)
      FROM (
        SELECT (l1).lid AS lid, ((l1).message_count - COALESCE((l2).message_count, 0)) AS message_count
          FROM unnest(ld1) l1
          LEFT JOIN unnest(ld2) l2
            ON ((l1).lid = (l2).lid)
      ) lg
      WHERE message_count != 0;
$$ LANGUAGE SQL IMMUTABLE;