CREATE OR REPLACE FUNCTION impl.oldest_mid(
    m1 impl.mid_with_date,
    m2 impl.mid_with_date
) RETURNS impl.mid_with_date AS $$
    SELECT CASE WHEN m1 IS NULL OR m2 IS NULL
                THEN coalesce(m1, m2)
                WHEN m1.received_date < m2.received_date
                THEN m1
                ELSE m2 END;
$$ LANGUAGE SQL IMMUTABLE;