CREATE OR REPLACE FUNCTION impl.sum_thread_labels(
    ld1 mail.thread_label[],
    ld2 mail.thread_label[]
) RETURNS mail.thread_label[] AS $$
    SELECT array_agg((lid, message_count)::mail.thread_label)
      FROM (
        SELECT lid, SUM(message_count) AS message_count
          FROM (
            SELECT (l1).lid AS lid, (l1).message_count AS message_count
              FROM unnest(ld1) l1
             UNION ALL
            SELECT (l2).lid, (l2).message_count
              FROM unnest(ld2) l2) ll
         GROUP BY lid
      ) lg
      WHERE message_count != 0;
$$ LANGUAGE SQL IMMUTABLE;