CREATE OR REPLACE FUNCTION impl.welcome_choice()
    RETURNS TABLE (country text, lang text, type impl.welcome_type) AS $$
        SELECT country, lang, type::impl.welcome_type
        FROM (VALUES
            ('de', 'en', 'en-int'),
            ('ru', 'en', 'en-rus'),
            ('ru', 'ru', 'ru-rus'),
            ('ru', 'tr', 'tr-tur'),
            ('ru', 'uk', 'uk-ua'),
            ('ru', 'undef', 'ru-rus'),
            ('tr', 'en', 'en-tur'),
            ('tr', 'ru', 'ru-rus'),
            ('tr', 'tr', 'tr-tur'),
            ('tr', 'uk', 'uk-ua'),
            ('tr', 'undef', 'en-tur'),
            ('ua', 'en', 'en-int'),
            ('ua', 'tr', 'tr-tur'),
            ('ua', 'uk', 'uk-ua'),
            ('undef', 'en', 'en-rus'),
            ('undef', 'ru', 'ru-rus'),
            ('undef', 'tr', 'tr-tur'),
            ('undef', 'uk', 'uk-ua'),
            ('undef', 'undef', 'ru-rus'),
            ('us', 'en', 'en-int'),
            ('us', 'ru', 'ru-rus'),
            ('us', 'tr', 'tr-tur'),
            ('us', 'uk', 'uk-ua'),
            ('us', 'undef', 'ru-rus')) AS v(country, lang, type);
$$ LANGUAGE sql IMMUTABLE;
