CREATE OR REPLACE FUNCTION impl.get_welcome_type(
    i_country  text,
    i_lang     text
) RETURNS impl.welcome_type
AS $$
DECLARE
    known_country  text;
    known_lang     text;
    welcome_type   impl.welcome_type;
BEGIN
    SELECT coalesce(max(country), 'undef')
      INTO known_country
      FROM impl.welcome_choice()
     WHERE country = i_country;

    SELECT coalesce(max(lang), 'undef')
      INTO known_lang
      FROM impl.welcome_choice()
     WHERE lang = i_lang;

    SELECT coalesce(max(wc.type), 'ru-rus'::impl.welcome_type)
      INTO welcome_type
      FROM impl.welcome_choice() wc
     WHERE wc.lang = known_lang AND wc.country = known_country;

    RETURN welcome_type;
END;
$$ LANGUAGE plpgsql IMMUTABLE;
