CREATE OR REPLACE FUNCTION impl.check_user_contact (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_contact_id bigint
) RETURNS void AS $$
BEGIN
    IF i_contact_id IS NULL THEN
        RAISE EXCEPTION 'i_contact_id is NULL' USING HINT = 'i_contact_id should not be NULL';
    END IF;

    IF NOT EXISTS (
        SELECT 1
          FROM contacts.contacts
         WHERE user_id = i_user_id AND user_type = i_user_type AND contact_id = i_contact_id
    ) THEN
        RAISE EXCEPTION 'Contact is not found for user: user_id: %, user_type: %, contact_id: %',
                i_user_id, i_user_type, i_contact_id
            USING HINT = 'Use contact that belongs to the user';
    END IF;
END;
$$ LANGUAGE plpgsql;
