CREATE OR REPLACE FUNCTION impl.check_user_contacts_email (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_email_id bigint
) RETURNS void AS $$
BEGIN
    IF i_email_id IS NULL THEN
        RAISE EXCEPTION 'i_email_id is NULL' USING HINT = 'i_email_id should not be NULL';
    END IF;

    IF NOT EXISTS (
        SELECT 1
          FROM contacts.emails
         WHERE user_id = i_user_id AND user_type = i_user_type AND email_id = i_email_id
    ) THEN
        RAISE EXCEPTION 'Email is not found for user: user_id: %, user_type: %, email_id: %',
                i_user_id, i_user_type, i_email_id
            USING HINT = 'Use email that belongs to the user';
    END IF;
END;
$$ LANGUAGE plpgsql;
