CREATE OR REPLACE FUNCTION impl.check_user_contacts_list (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_list_id bigint
) RETURNS void AS $$
BEGIN
    IF i_list_id IS NULL THEN
        RAISE EXCEPTION 'i_list_id is NULL' USING HINT = 'i_list_id should not be NULL';
    END IF;

    IF NOT EXISTS (
        SELECT 1
          FROM contacts.lists
         WHERE user_id = i_user_id AND user_type = i_user_type AND list_id = i_list_id
    ) THEN
        RAISE EXCEPTION 'List is not found for user: user_id: %, user_type: %, list_id: %',
                i_user_id, i_user_type, i_list_id
            USING HINT = 'Use list that belongs to the user';
    END IF;
END;
$$ LANGUAGE plpgsql;
