CREATE OR REPLACE FUNCTION impl.check_user_contacts_tag (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_tag_id bigint
) RETURNS void AS $$
BEGIN
    IF i_tag_id IS NULL THEN
        RAISE EXCEPTION 'i_tag_id is NULL' USING HINT = 'i_tag_id should not be NULL';
    END IF;

    IF NOT EXISTS (
        SELECT 1
          FROM contacts.tags
         WHERE user_id = i_user_id AND user_type = i_user_type AND tag_id = i_tag_id
    ) THEN
        RAISE EXCEPTION 'Tag is not found for user: user_id: %, user_type: %, tag_id: %',
                i_user_id, i_user_type, i_tag_id
            USING HINT = 'Use tag that belongs to the user';
    END IF;
END;
$$ LANGUAGE plpgsql;
