CREATE OR REPLACE FUNCTION impl.get_all_equivalent_contacts_revisions (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_revisions bigint[]
) RETURNS bigint[] AS $$
DECLARE
    revisions bigint[];
BEGIN
    SELECT array_agg(v.r)
      FROM (
        SELECT later_revision AS r
          FROM contacts.equivalent_revisions
         WHERE user_id = i_user_id
           AND user_type = i_user_type
           AND earlier_revision = ANY(i_revisions)
           AND later_revision <> ALL(i_revisions)
         UNION
        SELECT earlier_revision AS r
          FROM contacts.equivalent_revisions
         WHERE user_id = i_user_id
           AND user_type = i_user_type
           AND later_revision = ANY(i_revisions)
           AND earlier_revision <> ALL(i_revisions)
      ) AS v
      INTO revisions;

    IF revisions IS NULL THEN
        RETURN i_revisions;
    ELSE
        RETURN impl.get_all_equivalent_contacts_revisions(
            i_user_id := i_user_id,
            i_user_type := i_user_type,
            i_revisions := i_revisions || revisions
        );
    END IF;
END
$$ LANGUAGE plpgsql IMMUTABLE;
