CREATE OR REPLACE FUNCTION impl.increment_contacts_revision (
    i_user_id bigint,
    i_user_type contacts.user_type
) RETURNS bigint AS $$
DECLARE
    current_revision bigint;
BEGIN
    UPDATE contacts.serials
       SET next_revision = next_revision + 1
     WHERE user_id = i_user_id AND user_type = i_user_type
    RETURNING next_revision - 1 INTO current_revision;

    IF NOT FOUND THEN
        RAISE EXCEPTION 'No revision updated, user_id: %, user_type: %', i_user_id, i_user_type
              USING HINT = 'Probably user doesn''t exists',
                   TABLE = 'contacts.serials';
    END IF;

    RETURN current_revision;
END
$$ LANGUAGE plpgsql;
