CREATE OR REPLACE FUNCTION impl.new_chain_formula(
    rn           bigint,
    overall_add  bigint,
    last_chained impl.chained_message
) RETURNS smallint AS $$
SELECT
    CASE WHEN (last_chained).chain < impl.get_chain_size()
         THEN
         CASE WHEN (rn + coalesce((last_chained).chain, 0) - 1) % impl.get_chain_size() = 0
              THEN least(overall_add - rn + 1, impl.get_chain_size())::smallint
              ELSE NULL
          END
         ELSE
         CASE WHEN (rn - 1) % impl.get_chain_size() = 0
              THEN least(overall_add - rn + 1, impl.get_chain_size())::smallint
              ELSE NULL
          END
    END;
$$ LANGUAGE SQL IMMUTABLE;