CREATE OR REPLACE FUNCTION impl.untag_contacts (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_tag_id bigint,
    i_contact_ids bigint[],
    i_x_request_id text
) RETURNS bigint AS $$
DECLARE
    revision bigint := impl.acquire_current_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
    deleted_contact_ids bigint[];
BEGIN
    WITH d AS (
        DELETE FROM contacts.contacts_tags
         WHERE user_id = i_user_id
           AND user_type = i_user_type
           AND (i_tag_id IS NULL OR tag_id = i_tag_id)
           AND contact_id = ANY(i_contact_ids)
        RETURNING contact_id
    )
    SELECT array_agg(contact_id)
      FROM d
      INTO deleted_contact_ids;

    IF deleted_contact_ids IS NULL THEN
        RETURN revision - 1;
    END IF;

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'untag_contacts'::contacts.change_type,
        i_arguments := jsonb_build_object('tag_id', i_tag_id, 'contact_ids', i_contact_ids),
        i_changed := jsonb_build_object('contact_ids', deleted_contact_ids),
        i_x_request_id := i_x_request_id
    );

    RETURN impl.increment_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
END
$$ LANGUAGE plpgsql;
