CREATE OR REPLACE FUNCTION impl.untag_contacts_emails (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_tag_id bigint,
    i_email_ids bigint[],
    i_x_request_id text
) RETURNS bigint AS $$
DECLARE
    revision bigint := impl.acquire_current_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
    tagged_emails impl.tagged_email[];
BEGIN
    WITH d AS (
        DELETE FROM contacts.emails_tags
         WHERE user_id = i_user_id
           AND user_type = i_user_type
           AND (i_tag_id IS NULL OR tag_id = i_tag_id)
           AND email_id = ANY(i_email_ids)
        RETURNING email_id, contact_id
    )
    SELECT array_agg((d.email_id, d.contact_id)::impl.tagged_email)
      FROM d
      INTO tagged_emails;

    IF tagged_emails IS NULL THEN
        RETURN revision - 1;
    END IF;

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'untag_emails'::contacts.change_type,
        i_arguments := jsonb_build_object('tag_id', i_tag_id, 'email_ids', i_email_ids),
        i_changed := jsonb_build_object('tagged_emails', tagged_emails),
        i_x_request_id := i_x_request_id
    );

    RETURN impl.increment_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
END
$$ LANGUAGE plpgsql;
