CREATE OR REPLACE FUNCTION impl.update_contacts (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_contacts impl.contact[],
    i_revision bigint
) RETURNS void AS $$
DECLARE
    contact impl.contact;
BEGIN
    FOREACH contact IN ARRAY i_contacts LOOP
        UPDATE contacts.contacts
           SET revision = i_revision,
               list_id = contact.list_id,
               format = contact.format,
               vcard = contact.vcard,
               uri = contact.uri
         WHERE user_id = i_user_id AND user_type = i_user_type AND contact_id = contact.contact_id;
    END LOOP;
END
$$ LANGUAGE plpgsql;
