CREATE OR REPLACE FUNCTION impl.update_contacts_emails (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_emails impl.email[],
    i_revision bigint
) RETURNS void AS $$
DECLARE
    email impl.email;
BEGIN
    FOREACH email IN ARRAY i_emails LOOP
        UPDATE contacts.emails
           SET revision = i_revision,
               contact_id = email.contact_id,
               email = email.email,
               type = email.type,
               label = email.label
         WHERE user_id = i_user_id AND user_type = i_user_type AND email_id = email.email_id;
    END LOOP;
END
$$ LANGUAGE plpgsql;
