CREATE OR REPLACE FUNCTION impl.extract_fids(
    i_changed impl.changed_message[]
) RETURNS int[] AS $$
SELECT ARRAY(SELECT DISTINCT fid FROM unnest($1));
$$ LANGUAGE SQL IMMUTABLE;

CREATE OR REPLACE FUNCTION impl.extract_fids(
    i_changed impl.deleted_message[]
) RETURNS int[] AS $$
SELECT ARRAY(SELECT DISTINCT src_fid FROM unnest($1));
$$ LANGUAGE SQL IMMUTABLE;

CREATE OR REPLACE FUNCTION impl.extract_fids(
    i_changed impl.changed_message_with_src_fid_tab[]
) RETURNS int[] AS $$
SELECT ARRAY(
    SELECT DISTINCT fid
      FROM (SELECT ARRAY[src_fid, fid] fids
              FROM unnest($1)) cwn,
           unnest(fids) AS fid);
$$ LANGUAGE SQL IMMUTABLE;

CREATE OR REPLACE FUNCTION impl.extract_fids(
    i_changed impl.short_changed_message[]
) RETURNS int[] AS $$
SELECT ARRAY(SELECT DISTINCT fid FROM unnest($1));
$$ LANGUAGE SQL IMMUTABLE;

CREATE OR REPLACE FUNCTION impl.extract_fids(
    i_changed impl.synced_deleted_message[]
) RETURNS int[] AS $$
SELECT ARRAY(SELECT DISTINCT src_fid FROM unnest($1));
$$ LANGUAGE SQL IMMUTABLE;

CREATE OR REPLACE FUNCTION impl.extract_fids(
    i_changed impl.synced_short_changed_message[]
) RETURNS int[] AS $$
SELECT ARRAY(SELECT DISTINCT fid FROM unnest($1));
$$ LANGUAGE SQL IMMUTABLE;
