CREATE OR REPLACE FUNCTION impl.find_first_unseen(
    i_uid    bigint,
    i_fid    integer
) RETURNS impl.first_unseen_def AS $$
    SELECT (coalesce(max(pos), 0), max(imap_id))::impl.first_unseen_def
      FROM (
      SELECT *
        FROM (
            SELECT imap_id, seen, row_number() over () AS pos
              FROM (
                SELECT imap_id,
                       seen
                  FROM mail.box
                 WHERE uid = i_uid
                   AND fid = i_fid
              ORDER BY imap_id) m
      ) mf WHERE seen = false
      LIMIT 1) ma;
$$ LANGUAGE sql;


CREATE OR REPLACE FUNCTION impl.find_first_unseen(
    i_uid    bigint,
    i_fid    integer,
    i_prev_first_unseen    integer,
    i_prev_first_unseen_id bigint,
    i_moved                impl.moved_message[]
) RETURNS impl.first_unseen_def AS $$
DECLARE
    l_first_unseen_id bigint;
    l_first_unseen integer;
BEGIN
    -- find_first_unseen_id_greater_thEn_id
    select min(imap_id) INTO l_first_unseen_id
      from mail.box
     where uid = i_uid
       and fid = i_fid
       and imap_id >= i_prev_first_unseen_id
       and seen = false;
    if l_first_unseen_id is null then
        return (0, null)::impl.first_unseen_def;
    end if;

    select (
        i_prev_first_unseen - (
            -- Decrement position by number of messages prior previous first unseen (included) that have been moved away
            select count(*)
              from unnest(i_moved) t
             where src_fid = i_fid
               and t.src_imap_id <= i_prev_first_unseen_id
        ) + (
            -- Increment position by number of messages after previous first unseen and prior new first unseen (included)
            -- N.B. Move is already happened so no need to calculate moved-from and moved-to messages individually
            select count(*)
              from mail.box
             where uid = i_uid
               and fid = i_fid
               and imap_id > i_prev_first_unseen_id
               and imap_id <= l_first_unseen_id
        )
    ) into l_first_unseen;
    RETURN (l_first_unseen, l_first_unseen_id);
END;
$$ LANGUAGE plpgsql;
