CREATE OR REPLACE FUNCTION impl.get_useful_count(i_uid bigint)
RETURNS bigint AS $$
/*
as in oracle version useful_count is sum(message_unseen) from Inbox and user's folders
https://github.yandex-team.ru/mail/ora/blob/a53be7ce8e857e0dcbfd178e4cc866d5e2a0e3e3/packages/Operations_body.sql#L45
*/
SELECT sum(message_count) - sum(message_seen)
  FROM mail.folders
 WHERE uid = i_uid
   AND type IN ('inbox', 'user');
$$ LANGUAGE SQL STABLE;