CREATE OR REPLACE FUNCTION impl.make_mid(
    i_received_date timestamp with time zone,
    i_mid_serial    bigint
) RETURNS bigint AS $$
DECLARE
    days_from_epoch integer := extract(day from ((i_received_date - 'epoch')/30));
BEGIN
    IF days_from_epoch <= 0 THEN
        RETURN i_mid_serial;
    END IF;
    RETURN ((days_from_epoch)::bigint<<48) | i_mid_serial;
END;
$$ LANGUAGE plpgsql IMMUTABLE;