CREATE OR REPLACE FUNCTION impl.acquire_current_contacts_serials (
    i_user_id bigint,
    i_user_type contacts.user_type
) RETURNS contacts.serials AS $$
DECLARE
    serials contacts.serials;
BEGIN
    SELECT *
      FROM contacts.serials
     WHERE user_id = i_user_id AND user_type = i_user_type
       FOR NO KEY UPDATE
      INTO serials;
    IF NOT FOUND THEN
        RAISE EXCEPTION 'No serials selected, user_id: %, user_type: %', i_user_id, i_user_type
              USING HINT = 'Probably user doesn''t exists',
                   TABLE = 'contacts.serials';
    END IF;

    IF NOT impl.check_contacts_user_is_here(i_user_id, i_user_type) THEN
        RAISE EXCEPTION 'impl.acquire_current_contacts_serials: user (%, %) is not here', i_user_id,
            i_user_type;
    END IF;

    RETURN serials;
END
$$ LANGUAGE plpgsql;
