CREATE OR REPLACE FUNCTION impl.acquire_subscription(
    i_uid             bigint,
    i_subscription_id bigint
) RETURNS mail.shared_folder_subscriptions AS $$
DECLARE
    v_row mail.shared_folder_subscriptions;
BEGIN
    SELECT *
      INTO v_row
      FROM mail.shared_folder_subscriptions
     WHERE uid = i_uid
       AND subscription_id = i_subscription_id
       FOR NO KEY UPDATE;

    IF NOT found THEN
        RAISE EXCEPTION 'There are no subscription with (%, %) id', i_uid, i_subscription_id
                  USING TABLE = 'mail.shared_folder_subscriptions';
    END IF;

    RETURN v_row;
END;
$$ LANGUAGE plpgsql;