CREATE OR REPLACE FUNCTION impl.check_contacts_user_is_here(
    i_user_id bigint,
    i_user_type contacts.user_type
) RETURNS boolean AS $$
BEGIN
    IF EXISTS (
        SELECT 1
          FROM contacts.users
         WHERE user_id = i_user_id AND user_type = i_user_type AND is_here
           FOR NO KEY UPDATE
    ) THEN
        RETURN true;
    END IF;

    RETURN false;
END
$$ LANGUAGE plpgsql;
