CREATE OR REPLACE FUNCTION impl.find_min_earliest_equivalent_contacts_revision (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_current_revision bigint,
    i_min_revision bigint
) RETURNS bigint AS $$
    SELECT min(revision)
      FROM unnest(impl.get_all_equivalent_contacts_revisions(
          i_user_id := i_user_id,
          i_user_type := i_user_type,
          i_revisions := ARRAY[i_current_revision]::bigint[]
    )) AS revision
     WHERE i_min_revision <= revision AND revision < i_current_revision
$$ LANGUAGE SQL IMMUTABLE;
