CREATE OR REPLACE FUNCTION impl.get_found_tid(
    i_uid bigint,
    i_mid bigint
) RETURNS bigint AS $$
DECLARE
    i_found_tid bigint;
BEGIN
    SELECT found_tid
      INTO i_found_tid
      FROM mail.messages
     WHERE uid = i_uid AND mid = i_mid;

    IF i_found_tid IS NOT NULL THEN
        RETURN i_found_tid;
    END IF;

    SELECT tid
      INTO i_found_tid
      FROM mail.threads_messages
     WHERE uid = i_uid AND mid = i_mid;

    IF i_found_tid IS NOT NULL THEN
        RETURN i_found_tid;
    END IF;

    RETURN i_mid;
END;
$$ LANGUAGE plpgsql STABLE;