CREATE OR REPLACE FUNCTION impl.get_last_chained(
    i_uid bigint,
    i_fid integer
) RETURNS impl.chained_message AS $$
    /* return last (with max imap_id)
       chained (with chain IS NOT NULL) message */
    SELECT (imap_id, chain)::impl.chained_message
      FROM mail.box
     WHERE uid = i_uid
       AND fid = i_fid
       AND chain IS NOT NULL
     ORDER BY imap_id DESC
     LIMIT 1;
$$ LANGUAGE SQL;
