CREATE OR REPLACE FUNCTION impl.insert_changelog(
    i_uid              bigint,
    i_request_info     impl.request_info,
    i_revision         bigint,
    i_type             mail.change_type,
    i_fresh_count      bigint,
    i_useful_new_count bigint,
    i_changed          jsonb DEFAULT NULL,
    i_args             jsonb DEFAULT NULL,
    i_quiet            boolean DEFAULT NULL
) RETURNS bigint AS $$
DECLARE
    v_cid bigint := nextval('mail.cid_seq');
BEGIN
    INSERT INTO mail.change_log (
        cid,
        uid,
        revision,
        type,
        changed,
        arguments,
        fresh_count, useful_new_count,
        x_request_id, session_key,
        quiet
    ) SELECT
        v_cid,
        i_uid,
        i_revision,
        i_type,
        i_changed,
        i_args,
        i_fresh_count, i_useful_new_count,
        i_request_info.x_request_id, i_request_info.session_key,
        i_quiet;
    RETURN v_cid;
END;
$$ LANGUAGE plpgsql;
