CREATE OR REPLACE FUNCTION impl.revert_create_contacts (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_revision bigint,
    i_x_request_id text,
    i_change contacts.change_log
) RETURNS void AS $$
DECLARE
    contact_ids_to_delete bigint[];
    contacts_before_revert_delete impl.contact[];
BEGIN
    SELECT array_agg(contact_id)
      FROM jsonb_array_elements(i_change.changed->'contact_ids') AS contact_id
      INTO contact_ids_to_delete;

    SELECT array_agg((contact_id, list_id, format, vcard, uri)::impl.contact) v FROM contacts.contacts c
     WHERE user_id = i_user_id
       AND user_type = i_user_type
       AND contact_id IN (SELECT unnest(contact_ids_to_delete))
      INTO contacts_before_revert_delete;

    PERFORM impl.delete_contacts(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_contact_ids := contact_ids_to_delete
    );

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := i_revision,
        i_type := 'delete_contacts'::contacts.change_type,
        i_arguments := jsonb_build_object('contact_ids', contact_ids_to_delete),
        i_changed := jsonb_build_object('contacts', contacts_before_revert_delete),
        i_x_request_id := i_x_request_id,
        i_revert_change_id := i_change.change_id
    );
END
$$ LANGUAGE plpgsql;
