CREATE OR REPLACE FUNCTION impl.revert_create_contacts_emails (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_revision bigint,
    i_x_request_id text,
    i_change contacts.change_log
) RETURNS void AS $$
DECLARE
    email_ids_to_delete bigint[];
    emails_before_revert_delete impl.email[];
BEGIN
    SELECT array_agg(email_id)
      FROM jsonb_array_elements(i_change.changed->'email_ids') AS email_id
      INTO email_ids_to_delete;

    SELECT array_agg((email_id, contact_id, email, type, label)::impl.email) v FROM contacts.emails c
     WHERE user_id = i_user_id
       AND user_type = i_user_type
       AND email_id IN (SELECT unnest(email_ids_to_delete))
      INTO emails_before_revert_delete;

    PERFORM impl.delete_contacts_emails(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_email_ids := email_ids_to_delete
    );

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := i_revision,
        i_type := 'delete_emails'::contacts.change_type,
        i_arguments := jsonb_build_object('email_ids', email_ids_to_delete),
        i_changed := jsonb_build_object('emails', emails_before_revert_delete),
        i_x_request_id := i_x_request_id,
        i_revert_change_id := i_change.change_id
    );
END
$$ LANGUAGE plpgsql;
