CREATE OR REPLACE FUNCTION impl.revert_create_contacts_list (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_revision bigint,
    i_x_request_id text,
    i_change contacts.change_log
) RETURNS void AS $$
DECLARE
    list_name text;
    list_type contacts.list_type;
BEGIN
    SELECT name, type
      FROM contacts.lists
     WHERE user_id = i_user_id
       AND user_type = i_user_type
       AND list_id = (i_change.changed->>'list_id')::bigint
      INTO list_name, list_type;

    DELETE FROM contacts.lists
     WHERE user_id = i_user_id
       AND user_type = i_user_type
       AND list_id = (i_change.changed->>'list_id')::bigint;

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := i_revision,
        i_type := 'delete_list'::contacts.change_type,
        i_arguments := jsonb_build_object('list_id', i_change.changed->'list_id'),
        i_changed := jsonb_build_object('name', list_name, 'type', list_type),
        i_x_request_id := i_x_request_id,
        i_revert_change_id := i_change.change_id
    );
END
$$ LANGUAGE plpgsql;
