CREATE OR REPLACE FUNCTION impl.revert_create_contacts_tag (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_revision bigint,
    i_x_request_id text,
    i_change contacts.change_log
) RETURNS void AS $$
DECLARE
    tag_name text;
    tag_type contacts.tag_type;
BEGIN
    SELECT name, type
      FROM contacts.tags
     WHERE user_id = i_user_id AND user_type = i_user_type AND tag_id = (i_change.changed->>'tag_id')::bigint
      INTO tag_name, tag_type;

    DELETE FROM contacts.tags
     WHERE user_id = i_user_id AND user_type = i_user_type AND tag_id = (i_change.changed->>'tag_id')::bigint;

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := i_revision,
        i_type := 'delete_tag'::contacts.change_type,
        i_arguments := jsonb_build_object('tag_id', i_change.changed->'tag_id'),
        i_changed := jsonb_build_object('name', tag_name, 'type', tag_type),
        i_x_request_id := i_x_request_id,
        i_revert_change_id := i_change.change_id
    );
END
$$ LANGUAGE plpgsql;
