CREATE OR REPLACE FUNCTION impl.revert_delete_contacts (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_revision bigint,
    i_x_request_id text,
    i_change contacts.change_log
) RETURNS void AS $$
DECLARE
    contacts_to_create impl.contact[];
BEGIN
    SELECT array_agg((contact_id, list_id, format, vcard, uri)::impl.contact)
      FROM jsonb_to_recordset(i_change.changed->'contacts')
        AS (contact_id bigint, list_id bigint, format text, vcard jsonb, uri text)
      INTO contacts_to_create;

    PERFORM impl.create_contacts(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := i_revision,
        i_contacts := contacts_to_create
    );

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := i_revision,
        i_type := 'create_contacts'::contacts.change_type,
        i_arguments := jsonb_build_object('contacts', (
            SELECT array_agg((list_id, format, vcard, uri)::code.new_contact)
              FROM unnest(contacts_to_create)
        )),
        i_changed := jsonb_build_object('contact_ids', (
            SELECT array_agg(contact_id)
              FROM unnest(contacts_to_create)
        )),
        i_x_request_id := i_x_request_id,
        i_revert_change_id := i_change.change_id
    );
END
$$ LANGUAGE plpgsql;
