CREATE OR REPLACE FUNCTION impl.revert_delete_contacts_emails (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_revision bigint,
    i_x_request_id text,
    i_change contacts.change_log
) RETURNS void AS $$
DECLARE
    emails_to_create impl.email[];
BEGIN
    SELECT array_agg((email_id, contact_id, email, type, label)::impl.email)
      FROM jsonb_to_recordset(i_change.changed->'emails')
        AS (email_id bigint, contact_id bigint, email text, type text[], label text)
      INTO emails_to_create;

    PERFORM impl.create_contacts_emails(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := i_revision,
        i_emails := emails_to_create
    );

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := i_revision,
        i_type := 'create_emails'::contacts.change_type,
        i_arguments := jsonb_build_object('emails', (
            SELECT array_agg((contact_id, email, type, label)::code.new_contacts_email)
              FROM unnest(emails_to_create)
        )),
        i_changed := jsonb_build_object('email_ids', (
            SELECT array_agg(email_id)
              FROM unnest(emails_to_create)
        )),
        i_x_request_id := i_x_request_id,
        i_revert_change_id := i_change.change_id
    );
END
$$ LANGUAGE plpgsql;
