CREATE OR REPLACE FUNCTION impl.revert_share_contacts_list (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_revision bigint,
    i_x_request_id text,
    i_change contacts.change_log
) RETURNS void AS $$
BEGIN
    DELETE FROM contacts.shared_lists
     WHERE user_id = i_user_id
       AND user_type = i_user_type
       AND list_id = (i_change.arguments->>'list_id')::bigint
       AND client_user_id = (i_change.arguments->>'client_user_id')::bigint
       AND client_user_type = (i_change.arguments->>'client_user_type')::contacts.user_type;

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := i_revision,
        i_type := 'revoke_list'::contacts.change_type,
        i_arguments := jsonb_build_object(
            'list_id', i_change.arguments->'list_id',
            'client_user_id', i_change.arguments->'client_user_id',
            'client_user_type', i_change.arguments->'client_user_type'
        ),
        i_changed := jsonb_build_object(),
        i_x_request_id := i_x_request_id,
        i_revert_change_id := i_change.change_id
    );
END
$$ LANGUAGE plpgsql;
