CREATE OR REPLACE FUNCTION impl.revert_subscribe_to_contacts_list (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_revision bigint,
    i_x_request_id text,
    i_change contacts.change_log
) RETURNS void AS $$
BEGIN
    DELETE FROM contacts.subscribed_lists
     WHERE user_id = i_user_id
       AND user_type = i_user_type
       AND list_id = (i_change.arguments->>'list_id')::bigint
       AND owner_user_id = (i_change.arguments->>'owner_user_id')::bigint
       AND owner_user_type = (i_change.arguments->>'owner_user_type')::contacts.user_type
       AND owner_list_id = (i_change.arguments->>'owner_list_id')::bigint;

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := i_revision,
        i_type := 'revoke_subscribed_list'::contacts.change_type,
        i_arguments := jsonb_build_object(
            'list_id', i_change.arguments->'list_id',
            'owner_user_id', i_change.arguments->'owner_user_id',
            'owner_user_type', i_change.arguments->'owner_user_type',
            'owner_list_id', i_change.arguments->'owner_list_id'
        ),
        i_changed := jsonb_build_object(),
        i_x_request_id := i_x_request_id,
        i_revert_change_id := i_change.change_id
    );
END
$$ LANGUAGE plpgsql;
