CREATE OR REPLACE FUNCTION impl.revert_tag_contacts (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_revision bigint,
    i_x_request_id text,
    i_change contacts.change_log
) RETURNS void AS $$
BEGIN
    DELETE FROM contacts.contacts_tags
     WHERE user_id = i_user_id
       AND user_type = i_user_type
       AND tag_id = (i_change.arguments->>'tag_id')::bigint
       AND contact_id IN (
            SELECT value::text::bigint
              FROM jsonb_array_elements(i_change.changed->'contact_ids')
        );

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := i_revision,
        i_type := 'untag_contacts'::contacts.change_type,
        i_arguments := i_change.arguments,
        i_changed := i_change.changed,
        i_x_request_id := i_x_request_id,
        i_revert_change_id := i_change.change_id
    );
END
$$ LANGUAGE plpgsql;
