CREATE OR REPLACE FUNCTION impl.revert_untag_contacts (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_revision bigint,
    i_x_request_id text,
    i_change contacts.change_log
) RETURNS void AS $$
BEGIN
    INSERT INTO contacts.contacts_tags (user_id, user_type, contact_id, tag_id, revision)
    SELECT i_user_id, i_user_type, value::text::bigint, (i_change.arguments->>'tag_id')::bigint, i_revision
      FROM jsonb_array_elements(i_change.changed->'contact_ids');

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := i_revision,
        i_type := 'tag_contacts'::contacts.change_type,
        i_arguments := i_change.arguments,
        i_changed := i_change.changed,
        i_x_request_id := i_x_request_id,
        i_revert_change_id := i_change.change_id
    );
END
$$ LANGUAGE plpgsql;
