CREATE OR REPLACE FUNCTION impl.revert_update_contacts (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_revision bigint,
    i_x_request_id text,
    i_change contacts.change_log
) RETURNS void AS $$
DECLARE
    contacts_to_update impl.contact[];
    contacts_ids_to_update bigint[];
    contacts_before_revert_update impl.contact_to_update[];
BEGIN
    SELECT array_agg(contact_id)
      FROM jsonb_to_recordset(i_change.changed->'contacts')
        AS (contact_id bigint, list_id bigint, format contacts.vcard_format, vcard jsonb, uri text)
      INTO contacts_ids_to_update;

    SELECT array_agg((contact_id, list_id, format, vcard, revision, uri)::impl.contact_to_update)
      FROM contacts.contacts
     WHERE user_id = i_user_id
       AND user_type = i_user_type
       AND contact_id = ANY(SELECT contact_id FROM unnest(contacts_ids_to_update))
      INTO contacts_before_revert_update;

    SELECT array_agg((contact_id, list_id, format, vcard, uri)::impl.contact)
      FROM jsonb_to_recordset(i_change.changed->'contacts')
        AS (contact_id bigint, list_id bigint, format contacts.vcard_format, vcard jsonb, uri text)
      INTO contacts_to_update;

    PERFORM impl.update_contacts(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_contacts := contacts_to_update,
        i_revision := i_revision
    );

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := i_revision,
        i_type := 'update_contacts'::contacts.change_type,
        i_arguments := jsonb_build_object('contacts', contacts_to_update),
        i_changed := jsonb_build_object('contacts', (
            SELECT array_agg((contact_id, list_id, format, vcard, uri)::code.updated_contact)
              FROM unnest(contacts_before_revert_update)
        )),
        i_x_request_id := i_x_request_id,
        i_revert_change_id := i_change.change_id
    );
END
$$ LANGUAGE plpgsql;
