CREATE OR REPLACE FUNCTION impl.revert_update_contacts_emails (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_revision bigint,
    i_x_request_id text,
    i_change contacts.change_log
) RETURNS void AS $$
DECLARE
    emails_to_update impl.email[];
    emails_ids_to_update bigint[];
    emails_before_revert_update impl.email_to_update[];
BEGIN
    SELECT array_agg(email_id)
      FROM jsonb_to_recordset(i_change.changed->'emails')
        AS (email_id bigint, contact_id bigint, email text, type text[], label text)
      INTO emails_ids_to_update;

    SELECT array_agg((email_id, contact_id, email, type, label, revision)::impl.email_to_update)
      FROM contacts.emails
     WHERE user_id = i_user_id
       AND user_type = i_user_type
       AND email_id = ANY(SELECT email_id FROM unnest(emails_ids_to_update))
      INTO emails_before_revert_update;

    SELECT array_agg((email_id, contact_id, email, type, label)::impl.email)
      FROM jsonb_to_recordset(i_change.changed->'emails')
        AS (email_id bigint, contact_id bigint, email text, type text[], label text)
      INTO emails_to_update;

    PERFORM impl.update_contacts_emails(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_emails := emails_to_update,
        i_revision := i_revision
    );

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := i_revision,
        i_type := 'update_emails'::contacts.change_type,
        i_arguments := jsonb_build_object('emails', emails_to_update),
        i_changed := jsonb_build_object('emails', (
            SELECT array_agg((email_id, contact_id, email, type, label)::code.updated_contacts_email)
              FROM unnest(emails_before_revert_update)
        )),
        i_x_request_id := i_x_request_id,
        i_revert_change_id := i_change.change_id
    );
END
$$ LANGUAGE plpgsql;
