CREATE OR REPLACE FUNCTION impl.revert_update_contacts_tag (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_revision bigint,
    i_x_request_id text,
    i_change contacts.change_log
) RETURNS void AS $$
BEGIN
    UPDATE contacts.tags
       SET name = i_change.changed->>'name', revision = i_revision
     WHERE user_id = i_user_id
       AND user_type = i_user_type
       AND tag_id = (i_change.arguments->>'tag_id')::bigint;

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := i_revision,
        i_type := 'update_tag'::contacts.change_type,
        i_arguments := jsonb_build_object(
            'tag_id', i_change.arguments->'tag_id',
            'name', i_change.changed->'name'
        ),
        i_changed := jsonb_build_object('name', i_change.arguments->'name'),
        i_x_request_id := i_x_request_id,
        i_revert_change_id := i_change.change_id
    );
END
$$ LANGUAGE plpgsql;
