CREATE OR REPLACE FUNCTION impl.get_unsubscribe_filter(
    i_uid filters.rules.uid%type,
    i_email filters.conditions.pattern%type,
    i_message_type filters.conditions.pattern%type
) RETURNS BIGINT AS $$
    SELECT rule_id
      FROM filters.rules AS r
     WHERE uid = i_uid
       AND type = 'unsubscribe'
       AND EXISTS (
            SELECT 1
              FROM filters.conditions AS c
             WHERE c.uid = r.uid
               AND c.rule_id = r.rule_id
               AND field_type = 'header'
               AND field = 'from'
               AND pattern = i_email)
       AND EXISTS (
            SELECT 1
              FROM filters.conditions AS c
             WHERE c.uid = r.uid
               AND c.rule_id = r.rule_id
               AND field_type = 'type'
               AND field IS NULL
               AND pattern = i_message_type);
$$ language 'sql';
