CREATE OR REPLACE FUNCTION impl.make_actions(
    i_uid filters.actions.uid%type,
    i_acts TEXT[]
) RETURNS impl.action_def[] AS $$
DECLARE
    a_div constant SMALLINT := 3;
    v_res impl.action_def[];
    v_is_verified filters.actions.verified%type := FALSE;
    v_cur_param filters.actions.param%type;
    v_cur_oper filters.action_oper_type;
    v_verified_params TEXT[];
BEGIN
    IF array_length(i_acts, 1) % a_div != 0 THEN
        RAISE EXCEPTION 'Actions length is not a factor of %', a_div;
    END IF;

    v_verified_params := array(
      SELECT param
      FROM filters.actions
      WHERE
        uid = i_uid AND
        oper IN ('forward', 'forwardwithstore', 'notify') AND
        verified = TRUE);

    FOR i IN 1 .. array_length(i_acts, 1) / a_div LOOP
      v_is_verified := CAST(i_acts[i * a_div] AS BOOLEAN);
      v_cur_param := CAST(i_acts[i * a_div - 1] AS TEXT);
      v_cur_oper := CAST(i_acts[i * a_div - 2] AS filters.action_oper_type);

      SELECT
        v_is_verified OR (
          v_is_verified = FALSE AND
          v_cur_oper IN ('forward', 'forwardwithstore', 'notify') AND
          array[v_cur_param] <@ v_verified_params
      ) INTO v_is_verified;

      v_res := v_res || (v_cur_oper, v_cur_param, v_is_verified)::impl.action_def;
    END LOOP;

    RETURN v_res;
END;
$$ language 'plpgsql';
