CREATE OR REPLACE FUNCTION impl.make_conditions(
    i_conds TEXT[]
) RETURNS impl.condition_def[] AS $$
DECLARE
    c_div constant SMALLINT := 6;
    v_res impl.condition_def[];
    v_tmp_condition impl.condition_def;
BEGIN
    IF array_length(i_conds, 1) % c_div != 0 THEN
        RAISE EXCEPTION 'Conditions length is not a factor of %', c_div;
    END IF;

    FOR i IN 1 .. array_length(i_conds, 1) / c_div LOOP
      v_tmp_condition := CAST(ROW(
        CAST(i_conds[i * c_div - 5] AS filters.condition_field_type),
        i_conds[i * c_div - 4],
        i_conds[i * c_div - 3],
        CAST(i_conds[i * c_div - 2] AS filters.condition_oper_type),
        CAST(i_conds[i * c_div - 1] AS filters.condition_link_type),
        CAST(i_conds[i * c_div] AS BOOLEAN)
      ) AS impl.condition_def);

      v_res := v_res || v_tmp_condition;
    END LOOP;

    RETURN v_res;
END;
$$ language 'plpgsql';
