CREATE OR REPLACE FUNCTION impl.new_rule(
    i_new_id filters.rules.rule_id%type,
    i_uid filters.rules.uid%type,
    i_name filters.rules.name%type,
    i_enabled BOOLEAN,
    i_stop BOOLEAN,
    i_last BOOLEAN,
    i_type filters.rules.type%type,
    i_old_id filters.rules.rule_id%type = NULL
) RETURNS BIGINT AS $$
DECLARE
    v_rule_id filters.rules.rule_id%type;
    new_prio filters.rules.prio%type := NULL;
BEGIN
    IF i_new_id IS NULL THEN
      SELECT nextval('filters.rule_seq') INTO i_new_id;
    END IF;

    DELETE FROM filters.rules
     WHERE uid = i_uid
       AND rule_id = i_old_id
    RETURNING prio INTO new_prio;

    IF new_prio IS NULL THEN
      IF i_last THEN
        SELECT coalesce(max(prio), 0) + 1
          INTO new_prio
          FROM filters.rules WHERE uid = i_uid;
      ELSE
        SELECT coalesce(min(prio), 0) - 1
          INTO new_prio
          FROM filters.rules WHERE uid = i_uid;
      END IF;
    END IF;

    -- insert rule
    INSERT INTO filters.rules (
      uid, rule_id, name, enabled, prio, stop, type
    ) VALUES (
      i_uid, i_new_id, i_name, i_enabled, new_prio, i_stop, i_type
    ) RETURNING rule_id INTO v_rule_id;

    RETURN v_rule_id;
END;
$$ language 'plpgsql';
