CREATE OR REPLACE FUNCTION impl.update_chains_for_added_messages(
    i_uid            bigint,
    dst_fid          integer,
    moved            impl.moved_message[],
    last_chained     impl.chained_message
) RETURNS void AS $$
UPDATE mail.box
    SET chain = least(chain + cardinality(moved), impl.get_chain_size())
  FROM (
    SELECT (last_chained).imap_id AS last_id
      WHERE last_chained IS NOT NULL
        AND (last_chained).chain < impl.get_chain_size()) la
  WHERE uid = i_uid
    AND fid = dst_fid
    AND imap_id = last_id;
$$ LANGUAGE SQL;
